<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Booking extends Model 
{

    protected $table = 'booking';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function model()
    {
        return $this->hasOne('App\Models\Escort', 'escort_id');
    }

    public function service()
    {
        return $this->hasOne('App\Models\Service', 'service_id');
    }

}